global.config = {
    websiteUrl: "https://yourwebsite.com", // Must use HTTPS
    apiKey: "", // Dashboard > Settings > API
    serverToken: "", // Dashboard > Store > Servers > Server > Server Token
    checkPlayerOnline: true, // Check if player is online before executing commands
    lang: "en", // "en" or "tr"
    messages: {
        en: {
            connected: "[LeaderOS Connect] Successfully connected to the server!",
            queued: (id, cmd) => `[LeaderOS Connect] ${id} is offline, commands queued.`,
            joined: (id) => `[LeaderOS Connect] ${id} joined, commands executed from queue.`,
            error: (msg) => `[LeaderOS Connect] Error: ${msg}`,
            ping: "[LeaderOS Connect] Ping received from the server!",
            running: (id, cmd) => `[LeaderOS Connect] ${id} command: ${cmd}`
        },
        tr: {
            connected: "[LeaderOS Connect] Sunucuya başarıyla bağlanıldı!",
            queued: (id, cmd) => `[LeaderOS Connect] ${id} çevrimdışı, oyuncu sunucuya katıldıktan sonra komut çalıştırılacak: ${cmd}`,
            joined: (id) => `[LeaderOS Connect] ${id} oyuna katıldı, bekleyen komutlar çalıştırıldı.`,
            error: (msg) => `[LeaderOS Connect] Hata: ${msg}`,
            ping: "[LeaderOS Connect] Connect modülü başarıyla sunucuya bağlandı!",
            running: (id, cmd) => `[LeaderOS Connect] ${id} için komut çalıştırıldı: ${cmd}`
        }
    }
};
